/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.creeperhost.chickens.compat.jei.ChickenBreedingCategory;
import net.creeperhost.chickens.compat.jei.ChickenDropsCategory;
import net.creeperhost.chickens.compat.jei.ChickenLayingCategory;
import net.creeperhost.chickens.compat.jei.ChickenSubtypeInterpreter;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ChickensJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("chickens", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenBreedingCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenDropsCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenLayingCategory(jeiHelpers.getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CHICKEN_ITEM.get(), (IIngredientSubtypeInterpreter)ChickenSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(this.getBreedingRecipes(), ChickenBreedingCategory.UID);
        registry.addRecipes(this.getDropRecipes(), ChickenDropsCategory.UID);
        registry.addRecipes(this.getLayingRecipes(), ChickenLayingCategory.UID);
        registry.addRecipes(this.getSmeltingRecipes(), RecipeTypes.SMELTING.getUid());
    }

    private List<SmeltingRecipe> getSmeltingRecipes() {
        ArrayList<SmeltingRecipe> result = new ArrayList<SmeltingRecipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ItemStack itemstack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get(), 1);
            ItemChicken.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
            result.add(new SmeltingRecipe(chicken.getRegistryName(), "test", Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemstack}), new ItemStack((ItemLike)Items.f_42582_), 0.35f, 200));
        }
        return result;
    }

    private List<ChickenLayingCategory.Recipe> getLayingRecipes() {
        ArrayList<ChickenLayingCategory.Recipe> result = new ArrayList<ChickenLayingCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ItemStack itemstack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get(), 1);
            ItemChicken.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
            result.add(new ChickenLayingCategory.Recipe(itemstack, chicken.createLayItem()));
        }
        return result;
    }

    private List<ChickenDropsCategory.Recipe> getDropRecipes() {
        ArrayList<ChickenDropsCategory.Recipe> result = new ArrayList<ChickenDropsCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ItemStack itemstack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
            ItemChicken.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
            result.add(new ChickenDropsCategory.Recipe(itemstack, chicken.createDropItem()));
        }
        return result;
    }

    private List<ChickenBreedingCategory.Recipe> getBreedingRecipes() {
        ArrayList<ChickenBreedingCategory.Recipe> result = new ArrayList<ChickenBreedingCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (!chicken.isBreedable()) continue;
            ItemStack itemstack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
            ItemChicken.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
            ItemStack parent1 = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
            ItemChicken.applyEntityIdToItemStack(parent1, chicken.getParent1().getRegistryName());
            if (parent1 == null || parent1.m_41619_() || !(parent1.m_41720_() instanceof ItemChicken)) continue;
            ItemStack parent2 = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
            ItemChicken.applyEntityIdToItemStack(parent2, chicken.getParent2().getRegistryName());
            if (parent2 == null || parent2.m_41619_() || !(parent2.m_41720_() instanceof ItemChicken)) continue;
            result.add(new ChickenBreedingCategory.Recipe(parent1, parent2, itemstack, ChickensRegistry.getChildChance(chicken)));
        }
        return result;
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

